<?php
/**
 * YoutTube class
 * 
 * This source file can be used to embed video from YouTube and can display thumbnail for that video
 * 
 * The class is documented in the file itself. If you find any bugs help me out and report them. Reporting can be done by sending an email to imerovic[at]gmail[dot]com.
 * If you report a bug, make sure you give me enough information (include your code). 
 * 
 * @author		Ivan Imerovic <imerovic@gmail.com>
 * @version		1.0.0
 *
 * @copyright	Copyright (c) 2009, Ivan Imerovic. All rights reserved.
 * @license		BSD License
 */
class YouTube{
	
	/**
	 * The url for youtube video
	 *
	 * @var	string
	 */
	private $url;
	
	/**
	 * The id of youtube video
	 *
	 * @var	string
	 */
	private $videoId;
	
	/**
	 * Default constructor
	 *
	 * @return	void
	 * @param	string $url
	 */
	public function __construct($url){
		if($url !== null) $this->setVideoUrl($url);
	}
	
	// Public methods
	/**
	 * Get video thumbnail and display it
	 *
	 * @return	string
	 * @param	string[optional] $width
	 * @param	string[optional] $height
	 * @param	string[optional] $imageId
	 * 
	 */
	public function getThumbnail($width = 120, $height = 90, $imageId = '1'){
		return '<img src="http://img.youtube.com/vi/'.$this->videoId.'/'.$imageId.'.jpg" alt="" width="'.$width.'" height="'.$height.'" />';
	}
	
	/**
	 * Display embeded object of youtube video
	 *
	 * @return	string
	 * @param	string[optional] $width
	 * @param	string[optional] $height
	 * 
	 */
	public function embedVideo($width = 425, $height = 350){
		return '<object width="'.$width.'" height="'.$height.'"><param name="movie" value="http://www.youtube.com/v/'.$this->videoId.'"></param><param name="wmode" value="transparent"></param><embed src="http://www.youtube.com/v/'.$this->videoId.'" type="application/x-shockwave-flash" wmode="transparent" width="'.$width.'" height="'.$height.'"></embed></object>';
	}
	
	// Private methods
	/**
	 * Get video id from video url
	 *
	 * @return	void
	 * @param	string $url
	 * 
	 */
	private function getVideoIdFromUrl($url){
		$parts = explode('?v=',$url);
	    
		if(count($parts) == 2){
	        $tmp = explode('&', $parts[1]);
	        if(count($tmp) > 1){
	        	$this->videoId = (string) $tmp[0];
	        }
	        else{
	            $this->videoId = (string) $parts[1];
	        }
	    }
	    else{
	        $this->videoId = (string) $url;
	    }
	}
	
	// Getter / Setter
	/**
	 * Set video url
	 *
	 * @return	void
	 * @param	string $url
	 */
	public function setVideoUrl($url){
		$this->url = (string) $url;
		$this->getVideoIdFromUrl($this->url);
	}
	
	/**
	 * Get the video url
	 *
	 * @return	string
	 */
	public function getVideoUrl(){
		return (string) $this->url;
	}
	
	/**
	 * Set video id
	 *
	 * @return	void
	 * @param	string $videoId
	 */
	public function setVideoId($videoId){
		$this->videoId = (string) $videoId;
	}
	
	/**
	 * Get the video id
	 *
	 * @return	string
	 */
	public function getVideoId(){
		return (string) $this->videoId." video";
	}
}
?>